import pygame
import sys
from pygame.locals import *
from random import *

# Initialisation de Pygame
pygame.init()
pygame.font.init()

# Création de la fenêtre
fenetre = pygame.display.set_mode((1140, 641))
pygame.display.set_caption("Jeu de Vaisseau")

# Vitesse plus lente des astéroïdes
speed = [randint(1, 2), randint(1, 2)]
speed2 = [randint(1, 2), randint(1, 2)]

# Chargement des images
fond = pygame.image.load("fond2.jpg").convert()
logo = pygame.image.load("invader.png").convert_alpha()
asteroid = pygame.image.load("asteroid.png").convert_alpha()

# Création des rectangles
vaisseau = logo.get_rect()
astrect = asteroid.get_rect()
astrect2 = asteroid.get_rect()

# Placement initial des astéroïdes en bas à droite
astrect.bottomright = (1130, 630)
astrect2.bottomright = (1080, 600)

# Initialisation police pour message
font = pygame.font.SysFont("Arial", 72)

# Horloge pour limiter la vitesse de boucle
clock = pygame.time.Clock()

# Boucle principale du jeu
while True:
    # Gestion des événements
    for event in pygame.event.get():
        if event.type == QUIT:
            pygame.quit()
            sys.exit()

    # Récupération des touches clavier
    keys = pygame.key.get_pressed()
    dx, dy = 0, 0
    if keys[K_LEFT]:
        dx = -10
    if keys[K_RIGHT]:
        dx = 10
    if keys[K_UP]:
        dy = -10
    if keys[K_DOWN]:
        dy = 10

    # Déplacement du vaisseau
    vaisseau = vaisseau.move(dx, dy)
    vaisseau.clamp_ip(fenetre.get_rect())  # Reste dans la fenêtre

    # Déplacement des astéroïdes
    astrect = astrect.move(speed)
    astrect2 = astrect2.move(speed2)

    # Rebonds des astéroïdes
    if astrect.left < 0 or astrect.right > 1140:
        speed[0] = -speed[0]
    if astrect.top < 0 or astrect.bottom > 641:
        speed[1] = -speed[1]
    if astrect2.left < 0 or astrect2.right > 1140:
        speed2[0] = -speed2[0]
    if astrect2.top < 0 or astrect2.bottom > 641:
        speed2[1] = -speed2[1]

    # Détection de collision
    if vaisseau.colliderect(astrect) or vaisseau.colliderect(astrect2):
        fenetre.blit(fond, (0, 0))
        fenetre.blit(logo, vaisseau)
        fenetre.blit(asteroid, astrect)
        fenetre.blit(asteroid, astrect2)

        texte = font.render("GAME OVER", True, (255, 0, 0))
        fenetre.blit(texte, (350, 280))
        pygame.display.flip()

        pygame.time.delay(2000)
        pygame.quit()
        sys.exit("Le vaisseau a été détruit par un astéroïde !")

    # Affichage des éléments
    fenetre.blit(fond, (0, 0))
    fenetre.blit(logo, vaisseau)
    fenetre.blit(asteroid, astrect)
    fenetre.blit(asteroid, astrect2)
    pygame.display.flip()

    # Limite de la vitesse de la boucle
    clock.tick(100)
