#####################################
# apprentissage pygame
#####################################

import pygame
import sys
from pygame.locals import *
from random import *

# initialisation des modules de pygame
pygame.init()
# création de la surface graphique
fenetre=pygame.display.set_mode((1140,641))

# initialisation du mouvement aléatoire des asteroides
speed=[randint(1,5),randint(1,5)]
speed2=[randint(1,5),randint(1,5)]

# chargement des images
fond = pygame.image.load("fond2.jpg").convert()
logo = pygame.image.load("invader.png").convert_alpha()
asteroid=pygame.image.load("asteroid.png").convert_alpha()

# création des asteroids
astrect=asteroid.get_rect()
astrect2=asteroid.get_rect()

# création du vaisseau
vaisseau=logo.get_rect()

while 1: #boucle infinie
    # récupération des évènements
    for event in pygame.event.get():
        if event.type==pygame.QUIT: # sortie du programme
            sys.exit()
        # recupération des touches du clavier pour mouvement vaisseau
        keys = pygame.key.get_pressed()
        dx, dy = 0, 0
        if keys[pygame.K_LEFT]:
            dx = -10
        if keys[pygame.K_RIGHT]:
            dx = 10
        if keys[pygame.K_UP]:
            dy = -10
        if keys[pygame.K_DOWN]:
            dy = 10
    # mouvement du vaisseau
    vaisseau = vaisseau.move(dx,dy)
    # mouvement des asteroides
    astrect=astrect.move(speed)
    astrect2=astrect2.move(speed2)
    # rebonds des asteroides sur les parois
    if astrect.left<0 or astrect.right>1140:
        speed[0]=-speed[0]
    if astrect.top<0 or astrect.bottom>641:
        speed[1]=-speed[1]
    if astrect2.left<0 or astrect2.right>1140:
        speed2[0]=-speed2[0]
    if astrect2.top<0 or astrect2.bottom>641:
        speed2[1]=-speed2[1]
        
    # positionnement des images (calques)
    fenetre.blit(fond, (0,0))
    fenetre.blit(logo, vaisseau)
    fenetre.blit(asteroid,astrect)
    fenetre.blit(asteroid,astrect2)

    # limite des mouvements du vaisseau (taille de la fenetre)
    vaisseau.clamp_ip(fenetre.get_rect())

    #affichage des images
    pygame.display.flip()

    # Limiter la vitesse de la boucle
    pygame.time.Clock().tick(100)
