from cryptography.hazmat.primitives.asymmetric import rsa, padding
from cryptography.hazmat.primitives import serialization, hashes
import sys

# Message à chiffrer
message = b"Je suis Bob, comment ca va ?"

# Récupération de la clé publique
with open("public_key.pem", "rb") as g:
    key = serialization.load_pem_public_key(g.read())
    
# Chiffrement avec la clé publique
ciphertext = key.encrypt(
    message,
    padding.OAEP(
        mgf=padding.MGF1(algorithm=hashes.SHA256()),
        algorithm=hashes.SHA256(),
        label=None
    )
)

# Affichage du message chiffré
print("\nMessage chiffré :", ciphertext.hex())

# Ecriture du message chiffré dans un fichier
with open("datatext.bin", "wb") as f:
    f.write(ciphertext)

