from cryptography.hazmat.primitives.asymmetric import rsa, padding
from cryptography.hazmat.primitives import serialization, hashes

# Génération de la clé privée
private_key = rsa.generate_private_key(
    public_exponent=65537,
    key_size=4096
)
# Génération de la clé publique
public_key = private_key.public_key()

# Sérialisation de la clé privée
private_pem = private_key.private_bytes(
    encoding=serialization.Encoding.PEM,
    format=serialization.PrivateFormat.TraditionalOpenSSL,
    encryption_algorithm=serialization.NoEncryption()
)

# Sérialisation de la clé publique
public_pem = public_key.public_bytes(
    encoding=serialization.Encoding.PEM,
    format=serialization.PublicFormat.SubjectPublicKeyInfo
)

# Affichage des clés
print("Clé privée :\n", private_pem.decode())
print("\nClé publique :\n", public_pem.decode())

# écriture du fichier contenant la clé publique 
with open("public_key.pem", "wb") as g:
    g.write(public_pem)

# écriture du fichier contenant la clé privée
with open("private_key.pem", "wb") as g:
    g.write(private_pem)




