##### fonction qui récupère le code ASCII #####
def get_utf8(texte) :
    """
    Renvoie le tableau des codes ASCII/UTF8 de chaque caractère du message
    Entrée : texte (type str)
    Sortie : un tableau (type list) d'entiers
    """
    liste_ascii=[]
    for i in texte:
        liste_ascii.append(ord(i))
    return liste_ascii

assert get_utf8("NSI") == [78, 83, 73]

##### fonction qui récupère les caractères #####
def get_string(tab_utf8) :
    """
    Renvoie la chaine de caractères dont les codes ASCII/UTF8 sont les valeurs de tab_utf8
    Entrée : un tableau (type list) d'entiers 
    Sortie : une chaine de caractères (type str)
    """
    chaine=""
    for i in tab_utf8:
        chaine+=chr(i)
    return chaine
    
assert get_string([78, 83, 73]) == "NSI"

##### fonction qui réalise un XOR entre 2 tableaux #####
def chiffre_XOR(texte, clef) :
    """ Renvoie le tableau d'entiers obtenu par chiffrement XOR de texte avec clef comme clé de  chiffrement
    Entrées : texte et clef sont de type str
    Sortie : un tableau (type list) d'entiers
    """
    tab_utf8_texte = get_utf8(texte)
    tab_utf8_clef = get_utf8(clef)
    tab_xor = []
    for k in range(len(texte)) :
        nb_xor = tab_utf8_texte[k] ^ tab_utf8_clef[k%len(clef)]
        tab_xor.append(nb_xor)
    return tab_xor

assert chiffre_XOR("UN MESSAGE TRÈS SECRET", "NSI") == \
       [27, 29, 105, 3, 22, 26, 29, 18, 14, 11, 115, 29, 28, 155, 26, 110, 0, 12, 13, 1, 12, 26]

print(chiffre_XOR("UN MESSAGE TRÈS SECRET", "NSI"))


def dechiffre_XOR(tab_crypte, clef) :
    """ Renvoie le texte obtenu par déchiffrement du tableau tab_crypté avec clef comme clé de  chiffrement
    Entrées :
        tab_crypte est un tableau d'entiers
        clef est de type str
    Sortie : une chaine de caractères
    """
    chaine=""
    tab_utf8_clef = get_utf8(clef)
    tab_xor = []
    for k in range(len(tab_crypte)) :
        nb_xor = tab_crypte[k] ^ tab_utf8_clef[k%len(clef)]
        tab_xor.append(nb_xor)
    chaine=get_string(tab_xor)
    return chaine
    
assert dechiffre_XOR([27, 29, 105, 3, 22, 26, 29, 18, 14, 11, 115, 29, 28, 155, 26, 110, 0, 12, 13, 1, 12, 26], "NSI") \
       == "UN MESSAGE TRÈS SECRET"


print(dechiffre_XOR([27, 29, 105, 3, 22, 26, 29, 18, 14, 11, 115, 29, 28, 155, 26, 110, 0, 12, 13, 1, 12, 26], "NSI"))

