from cryptography.hazmat.primitives.asymmetric import rsa, padding
from cryptography.hazmat.primitives import serialization, hashes

# Récupération clé privée dans le fichier
with open("private_key.pem", "rb") as f:
    key = serialization.load_pem_private_key(
        f.read(),
        password=None  # Mettre un mot de passe si la clé est protégée
    )

# Récupération du message chiffré
with open("datatext.bin", "rb") as f:
    ciphertext = f.read()

# Déchiffrement du message avec la clé privée
decrypted_message = key.decrypt(
    ciphertext,
    padding.OAEP(
        mgf=padding.MGF1(algorithm=hashes.SHA256()),
        algorithm=hashes.SHA256(),
        label=None
    )
)

# Affichage du message déchiffré
print("\nMessage déchiffré :", decrypted_message.decode())



